# Supabase Table Editor - Getting Started

Welcome to the Supabase Table Editor! 🚀

## Quick Start

### First Time Setup
1. **Run Setup**: Visit `setup.php` in your browser to configure your Supabase connection
2. **Test Installation**: Visit `test.php` to verify everything is working correctly
3. **Launch Editor**: Visit `index.php` to start editing your tables

### Features Overview

✅ **View and Edit Tables** - Browse your Supabase data with inline editing  
✅ **Advanced Filtering** - Filter by any column to find specific records  
✅ **Global Search** - Search across all columns simultaneously  
✅ **Bulk Operations** - Select and delete multiple rows at once  
✅ **Data Export** - Export to CSV or JSON formats  
✅ **Table Statistics** - View detailed table information  
✅ **Add New Rows** - Insert records with a user-friendly form  
✅ **Responsive Design** - Works perfectly on desktop and mobile  

### File Structure
```
📁 Your Supabase Table Editor
├── 🚀 index.php        # Main application (start here after setup)
├── ⚙️ setup.php        # Initial configuration wizard
├── 🔧 test.php         # System diagnostics
├── 📝 README.md        # Comprehensive documentation
├── 📁 config/          # Configuration files
├── 📁 includes/        # PHP classes and functions
├── 📁 assets/          # CSS and JavaScript
├── 📁 api/             # REST API endpoints
└── 📁 temp/exports/    # Temporary export files
```

### Support
- 📖 **Full Documentation**: See `README.md` for detailed information
- 🔧 **Troubleshooting**: Run `test.php` for system diagnostics
- 🐛 **Issues**: Check browser console and PHP error logs

---
**Ready to get started?** Visit [setup.php](setup.php) to configure your connection!
